/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iaccess.launch;

import com.ibm.iaccess.launch.AcsDirectoryNames;
import com.ibm.iaccess.launch.AcsLaunchLocator;
import com.ibm.iaccess.launch.AcsLaunchPad;
import com.ibm.iaccess.launch.AcsStartupUtil;
import com.ibm.iaccess.launch.CopyrightLaunch;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileSystemView;

@CopyrightLaunch(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2022. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
public enum AcsProperties {
    INSTANCE;

    public static final String PREFIX_FOR_ALL_PROPERTIES = "com.ibm.iaccess.";
    public static final String BRACE_SYSTEM_BRACE = "{SYSTEM}";
    private Properties m_configProps;
    private volatile File m_userBaseDir;
    private static final String PRODUCTHELPSUBDIR = "iAccessClient_Help";
    private static final String PRODUCTSERVICESUBDIR = "iAccessClient_Service";
    private static final String PRODUCTSUBDIR = "iAccessClient";
    private static final String PROPFILERESOURCENAME = "AcsConfig.properties";
    private static final String PROPCOMMANDLINE = "ibmi.acs.configuration";
    private static File g_ibmDir;
    private static File g_prodDir;
    private static String g_rootDirKeywordVal;
    private static File g_tempDir;
    private String g_propstr;

    public static AcsProperties getProperties() {
        return INSTANCE;
    }

    /*
     * Exception decompiling
     */
    private AcsProperties() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static <E extends Exception> void throwAsUnchecked(Exception exception) throws E {
        throw exception;
    }

    private static <T, R, E extends Exception> Function<T, R> rethrowFunction(FunctionThrows<T, R, E> functionThrows) throws E {
        return object -> {
            try {
                return functionThrows.apply(object);
            }
            catch (Exception exception) {
                AcsProperties.throwAsUnchecked(exception);
                return null;
            }
        };
    }

    private static StringBuffer replaceAll(CharSequence charSequence, Pattern pattern, Function<Matcher, String> function) {
        Matcher matcher = pattern.matcher(charSequence);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(function.apply(matcher)));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer;
    }

    public static String processSystemKeyword(String string, String string2) {
        Matcher matcher = EnumConstants.SYS_PAT.matcher(string.trim());
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(string2));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private static String processKeywordsForProperty(Properties properties, String string) {
        if (null == string || string.isEmpty() || !string.contains("{")) {
            return string;
        }
        StringBuffer stringBuffer = AcsProperties.replaceAll(string.trim(), EnumConstants.USER_PAT, matcher -> System.getProperty("user.name"));
        try {
            stringBuffer = AcsProperties.replaceAll(stringBuffer, EnumConstants.PROD_PAT, AcsProperties.rethrowFunction(matcher -> AcsProperties.getProductDirKeywordVal() + File.separatorChar));
        }
        catch (Exception exception) {
            AcsStartupUtil.addDelayedLog(exception);
        }
        try {
            stringBuffer = AcsProperties.replaceAll(stringBuffer, EnumConstants.ROOT_PAT, AcsProperties.rethrowFunction(matcher -> AcsProperties.getRootDirKeywordVal() + File.separatorChar));
        }
        catch (Exception exception) {
            AcsStartupUtil.addDelayedLog(exception);
        }
        stringBuffer = AcsProperties.replaceAll(stringBuffer, EnumConstants.TEMP_PAT, matcher -> AcsProperties.getTempDir(properties).getAbsolutePath());
        stringBuffer = AcsProperties.replaceAll(stringBuffer, EnumConstants.CWD_PAT, matcher -> new File(".").getAbsolutePath() + File.separatorChar);
        stringBuffer = AcsProperties.replaceAll(stringBuffer, EnumConstants.HOME_PAT, matcher -> System.getProperty("user.home") + File.separatorChar);
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        File file = fileSystemView.getDefaultDirectory();
        String string2 = file.getAbsolutePath();
        stringBuffer = AcsProperties.replaceAll(stringBuffer, EnumConstants.DFLT_PAT, matcher -> string2 + File.separatorChar);
        if (0 <= stringBuffer.indexOf("{") && (stringBuffer.indexOf("{") != stringBuffer.lastIndexOf("{") || stringBuffer.indexOf("}") != stringBuffer.lastIndexOf("}") || stringBuffer.indexOf(BRACE_SYSTEM_BRACE) < 0)) {
            String string3 = "Unable to use string '" + string + "' as part of configuration setting! Exiting";
            new IOException(string3).printStackTrace();
            AcsStartupUtil.addDelayedLog(string3);
            AcsLaunchPad.m_pleaseWaitDialog.productSeemsStarted();
            JOptionPane.showMessageDialog(null, string3);
            System.exit(-7);
        }
        return stringBuffer.toString();
    }

    private static boolean isFileARoot(File file) {
        File file2 = file;
        try {
            file2 = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if ((FileSystemView.getFileSystemView().isDrive(file2) || FileSystemView.getFileSystemView().isFileSystemRoot(file2)) && FileSystemView.getFileSystemView().isFileSystem(file2)) {
            return true;
        }
        File[] fileArray = roo.g_roots;
        if (null != fileArray) {
            for (File file3 : fileArray) {
                if (!file2.equals(file3)) continue;
                return true;
            }
        }
        return file2.getAbsolutePath().matches("^[/]+(dev|mnt|media)[/]+[0-9a-zA-Z]+[/]*$");
    }

    private static String getRootDirKeywordVal() throws NullPointerException, SecurityException, URISyntaxException, IOException {
        if (Objects.nonNull(g_rootDirKeywordVal)) {
            return g_rootDirKeywordVal;
        }
        File file = AcsLaunchLocator.getLocator().getLocationType() == AcsLaunchLocator.LocationType.WEBSTART ? FileSystemView.getFileSystemView().getDefaultDirectory() : new File(AcsLaunchLocator.getLocator().getUrl().toURI());
        File file2 = null;
        while (true) {
            if (AcsProperties.isFileARoot(file)) {
                g_rootDirKeywordVal = file.getAbsolutePath();
                return g_rootDirKeywordVal;
            }
            file2 = file.getParentFile();
            if (null == file2) break;
            file = file2;
        }
        if (file.isDirectory()) {
            g_rootDirKeywordVal = file.getAbsolutePath();
            return g_rootDirKeywordVal;
        }
        throw new IOException();
    }

    private static String getProductDirKeywordVal() throws NullPointerException, SecurityException, URISyntaxException, IOException {
        File file = new File(AcsLaunchLocator.getLocator().getUrl().toURI());
        if ((file = file.getParentFile()).isDirectory()) {
            return file.getAbsolutePath();
        }
        throw new IOException();
    }

    public String getProperty(String string) {
        return this.getProperty(string, null);
    }

    public String getProperty(String string, String string2) {
        return AcsProperties.getProperty(this.m_configProps, string, string2);
    }

    private static String getProperty(Properties properties, String string, String string2) {
        String string3 = properties.getProperty(string);
        if (null == string3) {
            return string2;
        }
        if ((string3 = string3.trim()).length() == 0) {
            return string2;
        }
        return string3;
    }

    public int getIntProperty(String string, int n) {
        int n2 = -1;
        try {
            n2 = Integer.parseInt(this.getProperty(string, Integer.toString(n)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n2 <= 0) {
            n2 = n;
        }
        return n2;
    }

    Properties getPropertiesList() {
        Properties properties = new Properties();
        for (Map.Entry<Object, Object> entry : this.m_configProps.entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    public boolean isLmInProcess() {
        return Boolean.parseBoolean(this.getProperty("com.ibm.iaccess.InProcessLm", Boolean.FALSE.toString()));
    }

    public boolean isJavaAwtDesktopAllowed() {
        return Boolean.parseBoolean(this.getProperty("com.ibm.iaccess.javaAwtDesktopAllowed", Boolean.TRUE.toString()));
    }

    public boolean isLocalJarCaching() {
        String string = this.getProperty("com.ibm.iaccess.DataCache", Boolean.TRUE.toString());
        if (null != string && string.trim().equalsIgnoreCase("auto")) {
            switch (AcsLaunchLocator.getLocator().getLocationType()) {
                case FILE_PROBABLY_LOCAL: 
                case WEBSTART: 
                case FILE_UNKNOWN: {
                    return false;
                }
                case FILE_PROBABLY_REMOTE: {
                    return true;
                }
            }
            return false;
        }
        return Boolean.parseBoolean(string);
    }

    public boolean isInMemoryJarCaching() {
        String string = this.getProperty("com.ibm.iaccess.InMemCache", Boolean.FALSE.toString());
        if (null != string && string.trim().equalsIgnoreCase("auto")) {
            switch (AcsLaunchLocator.getLocator().getLocationType()) {
                case FILE_PROBABLY_LOCAL: 
                case WEBSTART: 
                case FILE_UNKNOWN: {
                    return false;
                }
                case FILE_PROBABLY_REMOTE: {
                    return true;
                }
            }
            return false;
        }
        return Boolean.parseBoolean(string);
    }

    public boolean isGTKAllowed() {
        return Boolean.parseBoolean(this.getProperty("com.ibm.iaccess.GTKLookAllowed", Boolean.TRUE.toString()));
    }

    public boolean isGTKForced() {
        return this.isGTKAllowed() && Boolean.parseBoolean(this.getProperty("com.ibm.iaccess.GTKLookForced", Boolean.FALSE.toString()));
    }

    public boolean isKerberosAutoConfig() {
        return Boolean.parseBoolean(this.getProperty("com.ibm.iaccess.KerberosAutoConfig", Boolean.TRUE.toString()));
    }

    public boolean isKerberosWindowsJGSSMode() {
        return Boolean.parseBoolean(this.getProperty("com.ibm.iaccess.WindowsJGSS", Boolean.FALSE.toString()));
    }

    public int getFFDCLogSizeInMB() {
        return this.getIntProperty("com.ibm.iaccess.FFDCLogSizeMb", 1);
    }

    public List<String> getExcludedComps() {
        String string = this.getProperty("com.ibm.iaccess.ExcludeComps", "");
        String[] stringArray = string.split("[,]+");
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string2 : stringArray) {
            String string3 = string2.trim().toLowerCase(Locale.US);
            if (string3.isEmpty()) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    public List<String> getIncludedComps() {
        String string = this.getProperty("com.ibm.iaccess.IncludeComps", "");
        String[] stringArray = string.split("[,]+");
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string2 : stringArray) {
            String string3 = string2.trim().toLowerCase(Locale.US);
            if (string3.isEmpty()) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString() + ":\n");
        for (Map.Entry<Object, Object> entry : this.m_configProps.entrySet()) {
            stringBuilder.append(entry.getKey().toString() + "=" + entry.getValue().toString() + "\n");
        }
        return stringBuilder.toString();
    }

    public File getProductDirectory() {
        if (Objects.nonNull(g_prodDir)) {
            return g_prodDir;
        }
        File file = new File(this.getIBMDirectory() + File.separator + PRODUCTSUBDIR + File.separator);
        file.mkdirs();
        g_prodDir = file;
        return g_prodDir;
    }

    private static File getTempDir(Properties properties) {
        boolean bl;
        String string = System.getProperty("java.io.tmpdir");
        String string2 = AcsProperties.getProperty(properties, "com.ibm.iaccess.tmpdir", null);
        boolean bl2 = bl = Objects.nonNull(string2) && !string2.equals(string);
        if (bl) {
            System.setProperty("java.io.tmpdir", string2);
        }
        File file = new File(bl ? string2 : string);
        file.mkdirs();
        return file;
    }

    public File getTempDir() {
        if (Objects.nonNull(g_tempDir)) {
            return g_tempDir;
        }
        g_tempDir = AcsProperties.getTempDir(this.m_configProps);
        return g_tempDir;
    }

    public static synchronized String makeRestrictedDir() throws IOException {
        File file = new File(AcsDirectoryNames.PWCACHES);
        file.mkdirs();
        file.setExecutable(false);
        file.setExecutable(true, true);
        file.setWritable(false);
        file.setWritable(true, true);
        file.setReadable(false);
        file.setReadable(true, true);
        boolean bl = true;
        bl = bl && file.exists();
        bl = bl && file.canRead();
        boolean bl2 = bl = bl && file.canWrite();
        if (!bl) {
            throw new IOException("Unable to create user-restricted directory");
        }
        return file.getCanonicalPath();
    }

    protected File getIBMDirectory() {
        if (Objects.nonNull(g_ibmDir)) {
            return g_ibmDir;
        }
        File file = new File(this.getUserBaseDirectory() + File.separator + "IBM" + File.separator);
        file.mkdirs();
        g_ibmDir = file;
        return g_ibmDir;
    }

    public String getMyDocumentsSubDir(String string) {
        String string2 = File.separator + "IBM" + File.separator + PRODUCTSUBDIR + File.separator;
        String string3 = this.getUserBaseDirectory().getAbsolutePath() + string2 + string;
        new File(string3).mkdirs();
        return string3;
    }

    public File getServiceDirectory() {
        File file = new File(this.getIBMDirectory() + File.separator + PRODUCTSERVICESUBDIR + File.separator);
        file.mkdirs();
        return file;
    }

    public String getHelpDirectory() {
        File file = new File(this.getIBMDirectory() + File.separator + PRODUCTHELPSUBDIR + File.separator);
        file.mkdirs();
        return file.getAbsolutePath();
    }

    public static String getJarCacheDirectory() {
        File file;
        String string = null;
        String string2 = System.getProperty("com.ibm.iaccess.JarCache");
        if (null != string2 && (file = new File(string2)).exists() && file.canWrite()) {
            try {
                string = file.getCanonicalPath();
            }
            catch (Exception exception) {
                AcsStartupUtil.addDelayedLog(exception);
                new IOException("Unable to use '" + string2 + "' for JarCache.").printStackTrace();
            }
        }
        if (null == string) {
            string = FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath();
        }
        string = string + File.separator + "IBM" + File.separator + PRODUCTSUBDIR + File.separator + "JarCache";
        new File(string).mkdirs();
        return string;
    }

    private File getUserBaseDirectory() {
        if (Objects.nonNull(this.m_userBaseDir)) {
            return this.m_userBaseDir;
        }
        String string = null;
        String string2 = this.getProperty("com.ibm.iaccess.AcsBaseDirectory");
        if (null != string2) {
            File file = new File(string2);
            file.mkdirs();
            if (file.exists() && file.canWrite() && file.isDirectory()) {
                try {
                    string = file.getCanonicalPath();
                }
                catch (Exception exception) {
                    AcsStartupUtil.addDelayedLog(exception);
                    String string3 = "Unable to use '" + string2 + "' as base directory for user configuration! Exiting";
                    new IOException(string3).printStackTrace();
                    AcsLaunchPad.m_pleaseWaitDialog.productSeemsStarted();
                    JOptionPane.showMessageDialog(null, string3);
                    System.exit(-7);
                }
            } else {
                String string4 = "Unable to use '" + string2 + "' as base directory for user configuration! Exiting";
                new IOException(string4).printStackTrace();
                AcsLaunchPad.m_pleaseWaitDialog.productSeemsStarted();
                JOptionPane.showMessageDialog(null, string4);
                System.exit(-7);
            }
        }
        if (null == string) {
            string = FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath();
        }
        this.m_userBaseDir = new File(string);
        return this.m_userBaseDir;
    }

    private static Properties loadPropertiesFromInputStream(Properties properties, InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        while (null != (string = bufferedReader.readLine())) {
            int n;
            if ((string = string.trim()).isEmpty() || string.charAt(0) == '#' || (n = string.indexOf(61)) <= 0) continue;
            String string2 = string.substring(0, n);
            String string3 = string.substring(1 + n);
            if (string3.isEmpty() || string2.isEmpty()) continue;
            properties.setProperty(string2, string3);
        }
        return properties;
    }

    public String getBrowser() {
        return this.getProperty("com.ibm.iaccess.browser", null);
    }

    public String getFileOpenCommand() {
        return this.getProperty("com.ibm.iaccess.fileopen", null);
    }

    public AutoImportFile getAutoImportFile() {
        String string = this.getProperty("com.ibm.iaccess.autoimport.version", null);
        String string2 = this.getProperty("com.ibm.iaccess.autoimport", null);
        return null == string || null == string2 || string.isEmpty() || string2.isEmpty() ? null : new AutoImportFile(string, string2);
    }

    public static boolean checkIfUserDirsAreWriteable() {
        File[] fileArray;
        AcsProperties acsProperties = AcsProperties.getProperties();
        for (File file : fileArray = new File[]{acsProperties.getProductDirectory(), acsProperties.getServiceDirectory(), new File(AcsDirectoryNames.USER_SETTINGS), new File(AcsDirectoryNames.DUMPS)}) {
            if (!file.exists() && !file.mkdirs()) {
                return false;
            }
            if (!file.isDirectory()) {
                return false;
            }
            if (!file.canRead()) {
                return false;
            }
            if (file.canWrite()) continue;
            return false;
        }
        return true;
    }

    public int getKerberosBufferSizeInKB() {
        return Math.min(this.getIntProperty("com.ibm.iaccess.KerberosTicketKb", 256), 6144);
    }

    public String getTLSAlgList() {
        return this.getProperty("com.ibm.iaccess.TLSAlgorithms", null);
    }

    public boolean isTLSProviderOrder() {
        return Boolean.parseBoolean(this.getProperty("com.ibm.iaccess.TLSProviderOrder", Boolean.FALSE.toString()));
    }

    public boolean isRedirectingStderr() {
        return Boolean.parseBoolean(this.getProperty("com.ibm.iaccess.CaptureStderr", Boolean.FALSE.toString()));
    }

    public boolean isRedirectingStdout() {
        return Boolean.parseBoolean(this.getProperty("com.ibm.iaccess.CaptureStdout", Boolean.FALSE.toString()));
    }

    public boolean isDumpOnExit() {
        return Boolean.parseBoolean(this.getProperty("com.ibm.iaccess.DumpOnExit", Boolean.FALSE.toString()));
    }

    public String getFonts() {
        return this.getProperty("com.ibm.iaccess.Fonts", "Fonts");
    }

    public boolean isUniqueSessionManager() {
        return Boolean.parseBoolean(this.getProperty("com.ibm.iaccess.UniqueSessionManager", Boolean.TRUE.toString()));
    }

    public String getDeploymentName() {
        return this.getProperty("com.ibm.iaccess.DeploymentName", null);
    }

    static {
        g_rootDirKeywordVal = null;
    }

    @CopyrightLaunch(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2022. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
    public static class AutoImportFile {
        public final String m_version;
        public final String m_file;

        private AutoImportFile(String string, String string2) {
            this.m_version = string;
            this.m_file = string2;
        }
    }

    private static class roo {
        private static final File[] g_roots = File.listRoots();

        private roo() {
        }
    }

    @FunctionalInterface
    private static interface FunctionThrows<T, R, E extends Exception> {
        public R apply(T var1) throws E;
    }

    static interface EnumConstants {
        public static final Pattern USER_PAT = Pattern.compile("(?i:\\{USER\\})");
        public static final Pattern PROD_PAT = Pattern.compile("^(?i:\\{PRODUCTDIR\\})");
        public static final Pattern ROOT_PAT = Pattern.compile("^(?i:\\{ROOT\\})");
        public static final Pattern TEMP_PAT = Pattern.compile("^(?i:\\{TEMPDIR\\})");
        public static final Pattern CWD_PAT = Pattern.compile("^(?i:\\{CWD\\})");
        public static final Pattern HOME_PAT = Pattern.compile("^(?i:\\{HOME\\})");
        public static final Pattern DFLT_PAT = Pattern.compile("^(?i:\\{DEFAULT\\})");
        public static final Pattern SYS_PAT = Pattern.compile("(?i:\\{SYSTEM\\})");
    }
}

