/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iaccess.launch;

import com.ibm.iaccess.launch.AcsByteBufferInputStream;
import com.ibm.iaccess.launch.AcsJarContentsCache;
import com.ibm.iaccess.launch.AcsLaunchLocator;
import com.ibm.iaccess.launch.AcsLock;
import com.ibm.iaccess.launch.AcsProperties;
import com.ibm.iaccess.launch.AcsStartupUtil;
import com.ibm.iaccess.launch.CopyrightLaunch;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

@CopyrightLaunch(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2022. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
public enum AcsJarFileMgr {
    INSTANCE;

    private static final Map<String, ByteBuffer> m_bufferResourceMap;
    private final Map<String, AcsLock> m_lockObjs = new HashMap<String, AcsLock>();

    public static AcsJarFileMgr getManager() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List<String> getNestedJarNames() throws IOException {
        Object object;
        AcsJarContentsCache acsJarContentsCache = AcsJarContentsCache.getCache();
        List<String> list = acsJarContentsCache.getJarEntriesForJar(AcsLaunchLocator.getLocator().getUrl());
        if (null != list) {
            AcsStartupUtil.addDelayedLog("Using Jar cache for nested jar names");
            return list;
        }
        AcsStartupUtil.addDelayedLog("Not using Jar cache for nested jar names");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!AcsLaunchLocator.getLocator().isInsideJarOrZip()) {
            return arrayList;
        }
        if (AcsLaunchLocator.getLocator().getLocationType() == AcsLaunchLocator.LocationType.WEBSTART) {
            object = null;
            try {
                String zipEntry;
                ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
                AcsStartupUtil.addDelayedLog("reading contents.txt");
                object = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream("contents.txt")));
                Object string = null;
                while (null != (zipEntry = ((BufferedReader)object).readLine())) {
                    String string2 = zipEntry.trim();
                    if (!string2.toLowerCase(Locale.US).endsWith(".jar") && !string2.toLowerCase(Locale.US).endsWith(".jar") || null == classLoader.getResource(string2)) continue;
                    acsJarContentsCache.putJarEntry(AcsLaunchLocator.getLocator().getUrl(), string2);
                    arrayList.add(string2);
                }
                ArrayList<String> arrayList2 = arrayList;
                return arrayList2;
            }
            catch (Exception exception) {
                if (AcsLaunchLocator.getLocator().getLocationType() == AcsLaunchLocator.LocationType.WEBSTART) {
                    exception.printStackTrace();
                }
                AcsStartupUtil.addDelayedLog("Error reading contents.txt: " + exception);
            }
            finally {
                if (null != object) {
                    ((BufferedReader)object).close();
                }
            }
        }
        arrayList.clear();
        try {
            object = new File(AcsLaunchLocator.getLocator().getUrl().toURI());
            for (ZipEntry zipEntry : Collections.list(new ZipFile((File)object).entries())) {
                if (zipEntry.isDirectory()) continue;
                acsJarContentsCache.putJarEntry(AcsLaunchLocator.getLocator().getUrl(), zipEntry.getName());
                arrayList.add(zipEntry.getName());
            }
            return arrayList;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            arrayList.clear();
            try (ZipInputStream zipInputStream = this.readJarFile(AcsLaunchLocator.getLocator().getUrl());){
                ZipEntry zipEntry;
                Object var6_16 = null;
                while (null != (zipEntry = zipInputStream.getNextEntry())) {
                    if (zipEntry.isDirectory()) continue;
                    acsJarContentsCache.putJarEntry(AcsLaunchLocator.getLocator().getUrl(), zipEntry.getName());
                    arrayList.add(zipEntry.getName());
                }
            }
            return arrayList;
        }
    }

    public static final String getManifestEntry(URL uRL) {
        ZipInputStream zipInputStream;
        AcsJarContentsCache acsJarContentsCache = AcsJarContentsCache.getCache();
        String string = acsJarContentsCache.getManifestOrNull(uRL);
        if (null != string) {
            AcsStartupUtil.addDelayedLog("Cached manifest for " + uRL);
            return string;
        }
        try {
            zipInputStream = AcsJarFileMgr.getManager().readJarFile(uRL);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            AcsStartupUtil.addDelayedLog(iOException);
            return "";
        }
        try {
            ZipEntry zipEntry = null;
            String string2 = "";
            while (null != (zipEntry = zipInputStream.getNextEntry())) {
                String string3 = zipEntry.getName();
                ByteBuffer byteBuffer = null;
                if (!"META-INF/MANIFEST.MF".equals(string3)) continue;
                byteBuffer = AcsStartupUtil.readEntireZipEntryToBuffer(zipInputStream, zipEntry);
                byte[] byArray = AcsStartupUtil.byteArrayFromByteBuffer(byteBuffer);
                string2 = new String(byArray, 0, byArray.length);
            }
            acsJarContentsCache.putManifest(uRL, string2);
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            AcsStartupUtil.addDelayedLog(exception);
            return "";
        }
    }

    public static void saveJarCache() {
        try {
            AcsJarContentsCache.getCache().write();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static ZipInputStream getSimpleZipStream(InputStream inputStream) {
        return new ZipInputStream(new BufferedInputStream(inputStream, 524288));
    }

    protected static ZipInputStream getSimpleZipStream(URL uRL) throws IOException {
        return AcsJarFileMgr.getSimpleZipStream(uRL.openStream());
    }

    public ZipInputStream readJarFile(URL uRL) throws IOException {
        String string = uRL.toString();
        if (string.toLowerCase(Locale.US).startsWith("jar:" + AcsLaunchLocator.getLocator().getUrl().toString().toLowerCase(Locale.US) + "!")) {
            return AcsJarFileMgr.getSimpleZipStream(this.readJarFilePlain(uRL));
        }
        AcsStartupUtil.addDelayedLog("Reading jar file the old way for " + uRL);
        return AcsJarFileMgr.getSimpleZipStream(uRL);
    }

    public InputStream readJarFilePlain(URL uRL) throws IOException {
        return this.readJarFilePlain(uRL.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream readJarFilePlain(String string) throws IOException {
        AcsLock acsLock = this.getLoadJarLockObject(string);
        synchronized (acsLock) {
            String string2 = string.replaceAll(".*!", "");
            if (!AcsProperties.getProperties().isInMemoryJarCaching()) {
                InputStream inputStream = AcsJarFileMgr.class.getResourceAsStream(string2);
                if (null == inputStream) {
                    throw new FileNotFoundException(string);
                }
                return inputStream;
            }
            ByteBuffer byteBuffer = m_bufferResourceMap.get(string2);
            if (null != byteBuffer) {
                return new AcsByteBufferInputStream(byteBuffer);
            }
            ByteBuffer byteBuffer2 = AcsStartupUtil.readEntireNestedJarToBuffer(string2);
            m_bufferResourceMap.put(string2, byteBuffer2);
            return new AcsByteBufferInputStream(byteBuffer2);
        }
    }

    private synchronized AcsLock getLoadJarLockObject(String string) {
        AcsLock acsLock = this.m_lockObjs.get(string);
        if (null != acsLock) {
            return acsLock;
        }
        AcsLock acsLock2 = new AcsLock(string);
        this.m_lockObjs.put(string, acsLock2);
        return acsLock2;
    }

    static {
        m_bufferResourceMap = new ConcurrentHashMap<String, ByteBuffer>();
    }
}

